<div class="content-wrapper">
  <section class="content container">
    <form method="post" enctype="multipart/form-data" action="<?php echo base_url('admin/business/invoice_customize') ?>" role="form" class="form-horizontal">

        <div class="nav-tabs-custom">
          
            <?php include"include/profile_menu.php"; ?>

            <div class="row m-5 mt-20">
              <div class="col-md-12 box">
                
                <div class="box-header">
                    <h3 class="box-title"><?php echo trans('invoice-customization') ?></h3>
                </div>

                <div class="box-body p-10">

                    
                    <div class="row p-30 mb-0">
                        <div class="col-md-12 p-5">
                            <p class="m-0"><?php echo trans('choose-invoice-templates') ?></p>
                        </div>
                        <?php 
                            if (user()->user_type == 'trial') {
                                $limit = 8;
                            } else {
                                $limit = check_package_limit('invoice_template');
                                if ($limit == -2) {
                                    $limit = 8;
                                }elseif ($limit == -1) {
                                    $limit =1;
                                } else {
                                    $limit = $limit;
                                }
                            }
                        ?>
                   
                        <?php for ($i=1; $i <= $limit; $i++) { ?>
                            <div class="col-md-2 text-center p-5">
                                <div class="invoice-layout <?php if($i==$this->business->template_style){echo "active";} ?>">
                                    <div class="invoice-img">
                                        <img src="<?php echo base_url() ?>assets/admin/layouts/invoice<?php echo $i ?>.png">
                                        <div class="iconv"><a data-toggle="modal" href="#templateModal_<?php echo $i ?>"><i class="icon-eye"></i></a></div>
                                    </div>
                                    <div class="radio radio-info radio-inline mt-10">
                                      <input type="radio" id="inlineRadio<?php echo $i ?>" <?php if($i==$this->business->template_style){echo "checked";} ?> value="<?php echo $i ?>" name="template_style">
                                      <label class="<?php if($i==$this->business->template_style){echo "text-primary";} ?>" for="inlineRadio<?php echo $i ?>"> <?php echo trans('template') ?> <?php echo $i ?> </label>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="row pl-30">
                        
                        <div class="col-2 p-10">
                            <div class="form-group p-0">
                                <p><?php echo trans('accent-color') ?></p>
                                <input type="text" name="color" class="colorpicker-default form-control colorpicker-element" value="<?php echo html_escape($this->business->color) ?>">
                            </div>
                        </div>
                        <div class="col-10 text-left">
                            <p></p><br>
                            <a class="colors-trigger colorpicker-advanced colorpicker-element mt-10" style="background-color: <?php echo html_escape($this->business->color) ?>" href="#"></a>
                        </div>
                    </div>


                    <div class="row pl-30 mb-20">
                        <div class="col-md-12 pl-10">
                            <div class="form-group">
                                  <input type="checkbox" id="md_checkbox_1" class="filled-in chk-col-blue" value="1" name="enable_qrcode" <?php if($this->business->enable_qrcode == 1){echo "checked";} ?>>
                                  <label for="md_checkbox_1"> <?php echo trans('enable-invoice-qr-code') ?></label>
                                  <p><?php echo trans('enable-qr-help') ?></p>
                              </div>
                        </div>
                    </div>


                    <div class="row pl-30">
                        <div class="col-md-12 pl-10">
                            <div class="form-group">
                                  <input type="checkbox" id="md_checkbox_2" class="filled-in chk-col-blue" value="1" name="enable_stock" <?php if($this->business->enable_stock == 1){echo "checked";} ?>>
                                  <label for="md_checkbox_2"> <?php echo trans('enable-stock') ?></label>
                                  <p><?php echo trans('enable-sotck-help') ?></p>
                              </div>
                        </div>
                    </div>


                    <div class="row pl-30">
                        <div class="col-md-12 pl-10">
                            <div class="form-group">
                                  <input type="checkbox" id="md_checkbox_3" class="filled-in chk-col-blue enable_input" value="1" name="enable_unit" <?php if($this->business->enable_unit == 1){echo "checked";} ?>>
                                  <label for="md_checkbox_3"> <?php echo trans('enable-unit') ?></label>
                                  <p><?php echo trans('enable-unit-help') ?></p>
                              </div>
                        </div>
                    </div>

                    <div class="row pl-30 unit_area <?php if($this->business->enable_unit==1){echo 'show';}else{echo 'hide';} ?>">
                        <div class="col-md-6 pl-10">
                            <div class="form-group">
                                <label><?php echo trans('unit') ?></label>
                                <input type="text" class="form-control" data-role="tagsinput" name="units" size="10" value="<?php echo html_escape($this->business->units) ?>">
                            </div>
                        </div>
                    </div>



                    <div class="row pl-30 mt-50">
                        <div class="col-md-6">
                            <h5 class="mb-20"><?php echo trans('default') ?> <?php echo trans('invoice') ?> <?php echo trans('settings') ?> <hr></h5>
                            <div class="form-group p-0">
                                <p><?php echo trans('invoice') ?> <?php echo trans('title') ?></p>
                                <input type="text" name="invoice_title" class="form-control" value="<?php echo html_escape($this->business->invoice_title) ?>">
                            </div>

                            <div class="form-group p-0">
                                <p><?php echo trans('invoice') ?> <?php echo trans('summary') ?></p>
                                <input type="text" name="invoice_summary" class="form-control" value="<?php echo html_escape($this->business->invoice_summary) ?>">
                            </div>

                            <div class="form-group p-0">
                                <p class="mb-2"><?php echo trans('set-default-footer-note') ?></p>
                                <textarea class="summernote form-control" name="footer_note" rows="4"><?php echo html_escape($this->business->footer_note) ?></textarea>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <h5 class="mb-20"><?php echo trans('default') ?> <?php echo trans('estimate') ?> <?php echo trans('settings') ?> <hr></h5>
                            <div class="form-group p-0">
                                <p><?php echo trans('estimate') ?> <?php echo trans('title') ?></p>
                                <input type="text" name="estimate_title" class="form-control" value="<?php echo html_escape($this->business->estimate_title) ?>">
                            </div>

                            <div class="form-group p-0">
                                <p><?php echo trans('estimate') ?> <?php echo trans('summary') ?></p>
                                <input type="text" name="estimate_summary" class="form-control" value="<?php echo html_escape($this->business->estimate_summary) ?>">
                            </div>

                            <div class="form-group p-0">
                                <p class="mb-2"><?php echo trans('set-default-footer-note-for-estimate') ?></p>
                                <textarea class="summernote form-control" name="estimate_footer_note" rows="4"><?php echo html_escape($this->business->estimate_footer_note) ?></textarea>
                            </div>
                        </div>

                    </div>


                    <div class="row pl-30">
                        <div class="col-md-12 pl-10">
                            <p class="m-0"><?php echo trans('footer-note-placement') ?></p>
                        </div>
                        <div class="p-10">
                            <div class="form-group p-0 row">
                                <div class="radio radio-info col-md-4">
                                   <input type="radio" id="inlineRadioLeft" value="left" name="footer_note_align" <?php if($this->business->footer_note_align == 'left'){echo "checked";} ?>>
                                   <label for="inlineRadioLeft"> <i class="fa fa-align-left" aria-hidden="true"></i></label>
                                </div>

                                <div class="radio radio-info col-md-4">
                                   <input type="radio" id="inlineRadioCenter" value="center" name="footer_note_align" <?php if($this->business->footer_note_align == 'center'){echo "checked";} ?>>
                                   <label for="inlineRadioCenter"> <i class="fa fa-align-center" aria-hidden="true"></i></label>
                                </div>

                                <div class="radio radio-info col-md-4">
                                   <input type="radio" id="inlineRadioRight" value="right" name="footer_note_align" <?php if($this->business->footer_note_align == 'right'){echo "checked";} ?>>
                                   <label for="inlineRadioRight"> <i class="fa fa-align-right" aria-hidden="true"></i></label>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>

                <div class="box-footer">
                    <!-- csrf token -->
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                    <button type="submit" class="btn btn-info waves-effect rounded w-md waves-light"><i class="fa fa-check"></i> <?php echo trans('save-changes') ?></button>
                </div>

              </div>
            </div>
        </div>
    </form>
  </section>
</div>


<?php for ($a=1; $a <= $limit; $a++) { ?>
    <div id="templateModal_<?php echo html_escape($a) ?>" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true">
        <div class="modal-dialog modal-dialog-zoom modal-lg">
            <div class="modal-content modal-md" style="margin-top: 10%">
                <div class="modal-header">
                    <h4 class="modal-title" id="vcenter">Invoice template - <?php echo html_escape($a) ?></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <img src="<?php echo base_url() ?>assets/admin/layouts/invoice<?php echo $a ?>.png">
                </div>
            </div>
        </div>
    </div>
<?php } ?>